<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BasicExtended;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class AboutPageController extends Controller
{
    public function imgtext(Request $request)
    {
        $lang = Language::where('code', $request->language)->firstOrFail();
        $data['lang_id'] = $lang->id;
        $data['abe'] = $lang->basic_extended;
        $data['abs'] = $lang->basic_setting;
        return view('admin.about.img-text', $data);
    }

    public function update(Request $request, $langid)
    {
        $about_features_section_image = $request->file('about_features_section_image');
        $about_testimonial_section_image = $request->file('about_testimonial_section_image');
        $about_counter_image = $request->file('about_counter_image');
        $allowedExts = array('jpg', 'png', 'jpeg');
        $rules = [
            'about_features_section_image' => [
                function ($attribute, $value, $fail) use ($request, $about_features_section_image, $allowedExts) {
                    if ($request->hasFile('about_features_section_image')) {
                        $ext = $about_features_section_image->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail(__("Only png, jpg, jpeg image is allowed"));
                        }
                    }
                },
            ],
            'about_testimonial_section_image' => [
                function ($attribute, $value, $fail) use ($request, $about_testimonial_section_image, $allowedExts) {
                    if ($request->hasFile('about_testimonial_section_image')) {
                        $ext = $about_testimonial_section_image->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail(__("Only png, jpg, jpeg image is allowed"));
                        }
                    }
                },
            ],
            'about_counter_image' => [
                function ($attribute, $value, $fail) use ($request, $about_counter_image, $allowedExts) {
                    if ($request->hasFile('about_counter_image')) {
                        $ext = $about_counter_image->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail(__("Only png, jpg, jpeg image is allowed"));
                        }
                    }
                },
            ],
            'about_features_section_title' => 'nullable|max:255',
            'about_features_section_subtitle' => 'nullable|max:255',
            'about_features_section_text' => 'nullable',
            'about_features_section_button_text' => 'nullable',
            'about_features_section_url' => 'nullable|max:255',
            
            'about_process_section_title' => 'nullable|max:255',
            'about_testimonial_section_title' => 'nullable|max:255',
            
            'about_blog_section_title' => 'nullable|max:255',
            //counter
            'about_counter_text' => 'nullable',
            'about_counter_title' => 'nullable | max:255',
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }


   
        $about_features_section_video_url = $request->about_features_section_video_url;
        if (strpos($about_features_section_video_url, '&') != 0) {
            $about_features_section_video_url = substr($about_features_section_video_url, 0, strpos($about_features_section_video_url, '&'));
        }
        
        $be = BasicExtended::where('language_id', $langid)->firstOrFail();

        //about section
        $be->about_testimonial_section_title = $request->about_testimonial_section_title;
        
        if ($request->hasFile('about_testimonial_section_image')) {
            @unlink(public_path('assets/front/img/' . $be->about_testimonial_section_image));
            $filename = uniqid() . '.' . $about_testimonial_section_image->getClientOriginalExtension();
            $about_testimonial_section_image->move(public_path('assets/front/img/'), $filename);
            $be->about_testimonial_section_image = $filename;
        }

        //features section
        $be->about_features_section_title = $request->about_features_section_title;
        $be->about_features_section_subtitle = $request->about_features_section_subtitle;
        $be->about_features_section_text = Purifier::clean($request->about_features_section_text, 'youtube');
        $be->about_features_section_button_text = $request->about_features_section_button_text;
        $be->about_features_section_url = $request->about_features_section_url;
        $be->about_features_section_video_url = $about_features_section_video_url;
        if ($request->hasFile('about_features_section_image')) {
            @unlink(public_path('assets/front/img/' . $be->about_features_section_image));
            $filename = uniqid() . '.' . $about_features_section_image->getClientOriginalExtension();
            $about_features_section_image->move(public_path('assets/front/img/'), $filename);
            $be->about_features_section_image = $filename;
        }

        //process section
        $be->about_process_section_title = $request->about_process_section_title;
        $be->about_blog_section_title = $request->about_blog_section_title;
        //counter sections

        if ($request->hasFile('about_counter_image')) {
            @unlink(public_path('assets/front/img/' . $be->about_counter_image));
            $filename = uniqid() . '.' . $about_counter_image->getClientOriginalExtension();
            $about_counter_image->move(public_path('assets/front/img/'), $filename);
            $be->about_counter_image = $filename;
        }

        $be->about_counter_title = $request->about_counter_title;
        $be->about_counter_text = Purifier::clean($request->about_counter_text, 'youtube');
        $be->save();


        Session::flash('success', __('Updated Successfully'));
        return "success";
    }
}
