<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class PackageBookingsExport implements FromCollection, WithHeadings, WithMapping
{
  protected $bookings;

  public function __construct($bookings)
  {
    $this->bookings = $bookings;
  }

  /**
   * @return \Illuminate\Support\Collection
   */
  public function collection()
  {
    return $this->bookings;
  }

  public function headings(): array
  {
    return [
      'Booking No.',
      'Customer Name',
      'Customer Number',
      'Customer Email',
      'Start Date',
      'End Date',
      'Price',
      'Discount',
      'Subtotal',
      'Tax',
      'Fee',
      'Grand Total',
      'Paid via',
      'Payment Status',
      'Booking Date'
    ];
  }

  /**
   * @var $booking
   */
  public function map($booking): array
  {
    // price
    if (is_null($booking->actual_total)) {
      $price = 'Requested';
    } else {
      $price = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->actual_total . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }

    // discount
    if (is_null($booking->discount)) {
      $discount = '-';
    } else {
      $discount = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->discount . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }

    // subtotal
    if (is_null($booking->subtotal)) {
      $subtotal = '-';
    } else {
      $subtotal = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->subtotal . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }

    // tax
    if (is_null($booking->tax)) {
      $tax = '-';
    } else {
      $tax = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->tax . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }

    // fee
    if (is_null($booking->fee)) {
      $fee = '-';
    } else {
      $fee = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->fee . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }


    // grand total
    if (is_null($booking->grand_total)) {
      $grandTotal = '-';
    } else {
      $grandTotal = ($booking->currency_symbol_position == 'left' ? $booking->currency_symbol . ' ' : '') . $booking->grand_total . ($booking->currency_symbol_position == 'right' ? ' ' . $booking->currency_symbol : '');
    }


    return [
      '#' . $booking->booking_number,
      $booking->customer_name,
      $booking->customer_phone,
      $booking->customer_email,
      $booking->startDate,
      $booking->endDate,
      $price,
      $discount,
      $subtotal,
      $tax,
      $fee,
      $grandTotal,
      is_null($booking->payment_method) ? '-' : $booking->payment_method,
      ucwords($booking->payment_status) == 1 ?  'Complete' : 'In Complete',
      $booking->createdAt
    ];
  }
}
